Vtiger.Class('AtomPipeline_Js', {},{
	// Disable x-axis scrolling during drag and drop
	disableScrollX:function() {
		document.body.style.overflowX = 'hidden';
	},
	// Enable x-axis scrolling after drag and drop
	enableScrollX:function() {
		document.body.style.overflowX = 'auto';
	},

	parseParamsFromURL:function (urlString) {
		const params = {};
		const queryString = urlString.split('?')[1];
		if (queryString) {
			const keyValuePairs = queryString.split('&');
			keyValuePairs.forEach(pair => {
				const [key, value] = pair.split('=');
				params[key] = decodeURIComponent(value);
			});
		}
		return params;
	},

	registerPiplelineButton:function(){
		var thisInstance = this;
		var params = {};
		params['module'] = 'AtomPipeline';
		params['action'] = 'CheckPipelineEnabledForModule';
		params['relModule'] = _META['module'];
		app.helper.showProgress();
		app.request.get({data:params}).then(function(err,data){
			app.helper.hideProgress();
			if(data == true )
			{
				var modulename = _META['module'];
				let cvid = $('[name="cvid"]').val();
				let pageStartRange = $('[name="pageStartRange"]').val();
				let pageEndRange = $('[name="pageEndRange"]').val();
				let page = $('[name="pageNumber"]').val();
				let buttonhtml = '<button class="btn pull-left atomModulePipeline" data-module="'+_META['module']+'" data-start="'+pageStartRange+'" data-cvid="'+cvid+'" data-end="'+pageEndRange+'" data-page="'+page+'" title="Pipeline View" style="border: 1px solid black;border-radius: 3px;margin-right: 10px;"><img src="layouts/v7/modules/AtomPipeline/pipe.png" style="width: 15px; height: 20px;"/></button>';
				$(".listViewActions > .btn-group").prepend( buttonhtml );
				thisInstance.registerPipeLineButtonOnPageChange();
			}
		});
	},

	getPaginationUrlParam: function( params ) {
		var urlparam = {};
		urlparam['module'] = params['relModule'];
		params['page'] = parseInt(params['page']);
		urlparam['view'] = 'List';
		urlparam['viewname'] = params['viewname'];
		if( params['direction'] == 'forward' ) {
			urlparam['page'] = params['page'] + 1;
		} else if( params['direction'] == 'backward' ) {
			urlparam['page'] = params['page'] - 1;
		} else if( params['direction'] == 'direction' ) {
			urlparam['page'] = params['page'];
		}
		urlparam['orderby'] = "";
		urlparam['sortorder'] = "";
		return urlparam;
	},

	registerKanbanPageToJumpSubmit: function() {	
		$(document).on('click','#kanbanPageToJumpSubmit',function(e){
			console.log("kanbanPageToJumpSubmit clicked");
			e.preventDefault();
			var params = {};
			history.pushState(params, null, window.location.pathname);
			params['module'] = 'AtomPipeline';
			params['view'] = 'PipelineChangePageView';
			params['relModule'] = $(this).data('module');
			params['viewname'] = $('[name="cvid"]').val();
			params['jumptopage'] = $('#pageToJump').val();
			params['direction'] = 'jumptopage';
			params['page'] = $('[name=pageNumber]').val();
			params['_pjax'] = '#pjaxContainer';
			app.helper.showProgress();
			app.request.get({data:params}).then(function(err,data){
				app.helper.hideProgress();
				$('#listViewContent').html(data);
				$('.listViewActionsContainer').hide();
				$("#NextPageButton").attr('id','kanbanNextPageButton');
				thisInstance.registerSortableEvent();
				
				let urlparam = thisInstance.getPaginationUrlParam(params);
				var newUrl = window.location.pathname + '?' + $.param(urlparam);
				history.pushState(urlparam, null, newUrl);
			});
		});
	},

	initializePaginationEvents: function () {
		var thisInstance = this;
		console.log("Inside initializePaginationEvents");
		$(document).on('click','#kanbanNextPageButton',function(e){
			console.log( "kanbanNextPageButton clicked" );
			let nextPageExist = $('#nextPageExist').val();
			if( nextPageExist == 1 ) {
				e.preventDefault();
				var params = {};
				history.pushState(params, null, window.location.pathname);
				params['module'] = 'AtomPipeline';
				params['view'] = 'PipelineChangePageView';
				params['relModule'] = $(this).data('module');
				params['viewname'] = $('[name="cvid"]').val();
				params['direction'] = 'forward';
				params['page'] = $('[name=pageNumber]').val();
				params['_pjax'] = '#pjaxContainer';
				app.helper.showProgress();
				app.request.get({data:params}).then(function(err,data){
					app.helper.hideProgress();
					$('#listViewContent').html(data);
					$('.listViewActionsContainer').hide();
					thisInstance.registerSortableEvent();
					
					let urlparam = thisInstance.getPaginationUrlParam(params);
					var newUrl = window.location.pathname + '?' + $.param(urlparam);
					history.pushState(urlparam, null, newUrl);
				});

			}
		});
		$(document).on('click','#kanbanPreviousPageButton',function(e){
			let previousPageExist = $('#previousPageExist').val();
			if( previousPageExist == 1 ) {
				e.preventDefault();
				var params = {};
				history.pushState(params, null, window.location.pathname);
				params['module'] = 'AtomPipeline';
				params['view'] = 'PipelineChangePageView';
				params['relModule'] = $(this).data('module');
				params['viewname'] = $('[name="cvid"]').val();
				params['direction'] = 'backward';
				params['page'] = $('[name=pageNumber]').val();
				params['_pjax'] = '#pjaxContainer';
				app.helper.showProgress();
				app.request.get({data:params}).then(function(err,data){
					app.helper.hideProgress();
					$('#listViewContent').html(data);
					$('.listViewActionsContainer').hide();
					thisInstance.registerSortableEvent();
					
					let urlparam = thisInstance.getPaginationUrlParam(params);
					var newUrl = window.location.pathname + '?' + $.param(urlparam);
					history.pushState(urlparam, null, newUrl);
				});
			}
		});

		$(document).on('click','#PageJump', function(e){
			console.log("PageJump clicked");
			thisInstance.registerKanbanPageToJumpSubmit();
		});

	},


        atomModulePipeline: function(){
		var thisInstance = this;
		$('body').on('click','.atomModulePipelineList',function(e){				
                        e.preventDefault();
                        var params = {};
                        params['module'] = $(this).data('module');
                        params['view'] = 'List';
			params['viewname'] = $('[name="cvid"]').val();
			params['start'] = $(this).data('start');
                        params['end'] = $(this).data('end');
			params['page'] = $(this).data('page');
			params['_pjax'] = '#pjaxContainer'
                        app.helper.showProgress();
                        app.request.get({data:params}).then(function(err,data){
                                app.helper.hideProgress();
                                $('#listViewContent').html(data);
				$('.listViewActionsContainer').show();
                        });
                });

                $('body').on('click','.atomModulePipeline',function(e){
                        e.preventDefault();
                        var params = {};
                        params['module'] = 'AtomPipeline';
                        params['view'] = 'PipelineView';
                        params['relModule'] = $(this).data('module');
			params['viewname'] = $('[name="cvid"]').val();
			params['start'] = $(this).data('start');
                        params['end'] = $(this).data('end');
			params['page'] = $(this).data('page');
                        app.helper.showProgress();
                        app.request.get({data:params}).then(function(err,data){
                                app.helper.hideProgress();
                                $('#listViewContent').html(data);
				$('.listViewActionsContainer').hide();
				thisInstance.registerSortableEvent();
				thisInstance.initializePaginationEvents();
                        });
                });
        },

	registerSortableEvent:function(){
		console.log( "registerSortableEvent" );
		var thisInstance = this;
		var startstage = "";
		var tostage = "";
		jQuery('.pipelinecolumnblock').sortable({
			connectWith: ".pipelinecolumnblock",
			handle: ".recordlabelheader",
			start: function(e,ui){
				//thisInstance.disableScrollX();
				var item = ui.item;
				startstage = item.closest('.pipelinecolumnwrapper').find('.optionname').val()
			},
			stop: function(event,ui){
				//thisInstance.enableScrollX();
				var item = ui.item;
				var params = {};
				tostage = item.closest('.pipelinecolumnwrapper').find('.optionname').val();;
				if( startstage != tostage ) {
					params['module'] = 'AtomPipeline';
					params['view'] = 'MovePipeLineStage';
					params['relModule'] = _META['module'];
					params['recordid'] = item.data('recordid');
					params['tostage'] = tostage;
					params['cvid'] = $('[name="cvid"]').val();
					app.helper.showProgress();
					app.request.get({data:params}).then(function(err,data){
						app.helper.hideProgress();
						if( data != "" ) {
							item.replaceWith( data );
						}
					});
				} else {
					//app.helper.showAlertBox({"message":"This ordering of records not supported yet"})
				}
			},
		});
	},

	registerPipeLineButtonOnPageChange:function(){
		var thisInstance = this;
		$(document).ajaxComplete(function( event,xhr,options ){
			let urlString = options.url;
			let extractedParams = thisInstance.parseParamsFromURL(urlString);
			if( extractedParams['module'] == _META['module'] && extractedParams['view'] == 'List' && 'page' in extractedParams && 'viewname' in extractedParams ) {
				let cvid = $('[name="cvid"]').val();
				let pageStartRange = $('[name="pageStartRange"]').val();
				let pageEndRange = $('[name="pageEndRange"]').val();
				let page = $('[name="pageNumber"]').val();
				if( $('button.atomModulePipeline').length > 0 ) {
					let pipelinebutton = $('button.atomModulePipeline');
					pipelinebutton.data('start' , pageStartRange );
					pipelinebutton.data('end' , pageEndRange );
				} else {
					let buttonhtml = '<button class="btn pull-left atomModulePipeline" data-module="'+_META['module']+'" data-start="'+pageStartRange+'" data-cvid="'+cvid+'" data-end="'+pageEndRange+'" data-page="'+page+'" title="Pipeline View" style="border: 1px solid black;border-radius: 3px;margin-right: 10px;"><img src="layouts/v7/modules/AtomPipeline/pipe.png" style="width: 15px; height: 20px;"/></button>';
					$(".listViewActions > .btn-group").prepend( buttonhtml );
				}
			}
		});
	
	},


        registerEvents: function(){
                this.atomModulePipeline();
		this.registerPiplelineButton();
        },
});

$(document).ready(function(){
	if( _META['view'] == 'List' ) {
		var myInstance = new AtomPipeline_Js();
		myInstance.registerEvents();
	}
})
