<?php
class AtomPipeline{
	function vtlib_handler($moduleName, $eventType) {
		if ($moduleName == 'AtomPipeline') {
			$db = PearDatabase::getInstance();
			if ($eventType == 'module.disabled') {
				$db->pquery('UPDATE vtiger_settings_field SET active=1 WHERE name=?', array('Atom Pipeline Settings'));
				$this->deleteHeaderLink();
			} else if ($eventType == 'module.enabled') {
				$db->pquery('UPDATE vtiger_settings_field SET active=0 WHERE name=?', array('Atom Pipeline Settings'));
				$this->createSettingPage();
				$this->insertHeaderLink();
			} else if( $eventType == 'module.preuninstall' ) {
				$db->pquery('UPDATE vtiger_settings_field SET active=1 WHERE name=?', array('Atom Pipeline Settings'));	
				$this->deleteHeaderLink();
			} else if( $eventType == 'module.postinstall' ) {
				$db->pquery('UPDATE vtiger_settings_field SET active=0 WHERE name=?', array('Atom Pipeline Settings'));
				$this->createSettingPage();
				$this->insertHeaderLink();
			} else if( $eventType == 'module.postupdate' ) {
				$db->pquery('UPDATE vtiger_settings_field SET active=0 WHERE name=?', array('Atom Pipeline Settings'));
				$this->createSettingPage();
				$this->insertHeaderLink();
			}
		}
	}

	function createSettingPage(){
		global $adb;
		$nextNum = $adb->pquery('select id from vtiger_settings_field_seq');
		$fieldId = $adb->query_result($nextNum, 0 , 'id');
		$fieldId ++;

		$link = 'index.php?module=AtomPipeline&parent=Settings&view=AtomPipeline';
		$block_res = $adb->pquery("SELECT blockid FROM vtiger_settings_blocks WHERE label = ?",array( 'LBL_CONFIGURATION' ));
		if( $adb->num_rows( $block_res ) > 0 ) {
			$blockid = $adb->query_result( $block_res , 0 , 'blockid' );
		}
		$tableValue = $adb->pquery("select name,linkto from vtiger_settings_field WHERE name=? and linkto=?",array('Atom Pipeline Settings',$link));
		$num_rows = $adb->num_rows($tableValue);
		if( $num_rows === 0 ) {
			$fieldseq_res = $adb->pquery("SELECT MAX( sequence ) as sequence FROM vtiger_settings_field WHERE blockid = ?" , array( $blockid ) );
			if( $adb->num_rows( $fieldseq_res ) > 0 ) 
			{
				$seq = (int)$adb->query_result( $fieldseq_res , 0 , 'sequence' );
				$seq++;
			}
			else {
				$seq = 1;
			}
			$adb->pquery("INSERT into vtiger_settings_field(fieldid,blockid,name,linkto , sequence ) VALUES (?,?,?,?, ? )",array($fieldId, $blockid ,'Atom Pipeline Settings',$link , $seq ));
			$adb->pquery("update vtiger_settings_field_seq set id=?",array($fieldId));
		}
	}

	function insertHeaderLink(){
		$linklabel = "Atom Pipeline JS";
		$linkurl = "layouts/v7/modules/AtomPipeline/resources/AtomPipeline.js";
		Vtiger_Link::addLink( 0 , 'HEADERSCRIPT' , $linklabel , $linkurl );
	}

	function deleteHeaderLink() {
		$linklabel = "Atom Pipeline JS";
		$linkurl = "layouts/v7/modules/AtomPipeline/resources/AtomPipeline.js";
		Vtiger_Link::deleteLink( 0 , 'HEADERSCRIPT' , $linklabel , $linkurl );
	}
}
