<?php
// AtomPipline.php
class AtomPipeline{
	function vtlib_handler($moduleName, $eventType) {
		if ($moduleName == 'AtomPipeline') {
			$db = PearDatabase::getInstance();
			include_once 'modules/AtomPipeline/AtomPipelineCustomFile.php';
			$AtomPipelineCustom = new AtomPipelineCustom();
			if ($eventType == 'module.disabled') {
				$db->pquery('UPDATE vtiger_settings_field SET active=1 WHERE name=?', array('Atom Pipeline Settings'));

				$AtomPipelineCustom->postDisable();
			} else if ($eventType == 'module.enabled') {
				$db->pquery('UPDATE vtiger_settings_field SET active=0 WHERE name=?', array('Atom Pipeline Settings'));

				$AtomPipelineCustom->LicenseSettingsLink();
				$AtomPipelineCustom->postEnable();
				//$this->insertHeaderLink();
				$this->createCustomTables();
			} else if( $eventType == 'module.preuninstall' ) {
				$db->pquery('UPDATE vtiger_settings_field SET active=1 WHERE name=?', array('Atom Pipeline Settings'));	
				$AtomPipelineCustom->postDisable();
			} else if( $eventType == 'module.postinstall' ) {
				$db->pquery('UPDATE vtiger_settings_field SET active=0 WHERE name=?', array('Atom Pipeline Settings'));
				$AtomPipelineCustom->LicenseSettingsLink();
				//$this->insertHeaderLink();
				$this->createCustomTables();
			} else if( $eventType == 'module.postupdate' ) {
				$db->pquery('UPDATE vtiger_settings_field SET active=0 WHERE name=?', array('Atom Pipeline Settings'));
				$AtomPipelineCustom->LicenseSettingsLink();
				//$this->insertHeaderLink();
				$this->createCustomTables();
			}
		}
	}

	function createCustomTables(){
		global $adb;

		$table_sql['atom_license_manager'] = "CREATE TABLE `atom_license_manager` (
			`id` int NOT NULL AUTO_INCREMENT,
			`meta_key` varchar(255) NOT NULL,
			`meta_value` longtext NOT NULL,
			PRIMARY KEY (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3";

		foreach($table_sql as $table_name => $sql){
			$table_exist_result = $adb->pquery("SHOW TABLES LIKE '$table_name'",array());
			$num_rows = $adb->num_rows($table_exist_result);

			if($num_rows == 0){
				$adb->pquery($sql,array());
			}

		}
		$adb->pquery("UPDATE vtiger_tab SET customized = 0 WHERE name = 'AtomPipeline'",array());
	}

}
