<?php
include_once 'vtlib/Vtiger/Module.php';
include_once 'vtlib/Vtiger/ListView.php';

class AtomPipeline_AtomPipelinePage_View extends Vtiger_Index_View
{
	public function process(Vtiger_Request $request)
	{
		global $adb;

		$viewer = $this->getViewer($request);
		$moduleName = $request->getModule();
		$relModule = $request->get('relModule');
		$page = $request->get('start');
		$limit = $request->get('end');

		$result = $adb->pquery('SELECT field_name FROM atom_pipeline_settings WHERE module_name = ?', array($relModule));

		if ($adb->num_rows($result) > 0) {
			$fieldName = $adb->query_result($result, 0, 'field_name');
			$fieldModel = Vtiger_Field_Model::getInstance($fieldName, Vtiger_Module_Model::getInstance($relModule));

			if ($fieldModel->getFieldDataType() == 'picklist') {
				$picklistValues = $fieldModel->getPicklistValues();
			}

			$viewer->assign('PICKLIST_VALUES', $picklistValues);
			$viewer->assign('FIELD_NAME', $fieldName);
		}

		$getPageNationRecords = $this->getPageNationRecords($relModule, $page, $limit, $viewer);
		$viewer->view('AtomPipelinePage.tpl', $moduleName);
	}
	public function getPageNationRecords($moduleName, $page, $limit, $viewer)
	{
		global $adb;
		$moduleName = 'Products';

		$pageLimit = 10;

		$currentPage = 1; // You can adjust this as needed

		$pagingModel = new Vtiger_Paging_Model();
		$pagingModel->set('limit', $pageLimit);
		$pagingModel->set('page', $currentPage);

		//$productRecords = Vtiger_Record_Model::getAll($moduleName, $pagingModel);

	}

}

