<?php

class AtomsMSmtp_getServerSelectHtml_Action extends Vtiger_Action_Controller {


	public function checkPermission( Vtiger_Request $request) {
		return true;
	}
	public function process(Vtiger_Request $request) {
		global $adb , $current_user ;
		$return = '';

		$current_user_id = $current_user->id;

		$result = $adb->pquery("SELECT * FROM vtiger_atoms_msmtp WHERE config_type = ?",array('public'));		
		$num_rows = $adb->num_rows($result);
		$systemresult = $adb->pquery( "SELECT * FROM vtiger_systems where server_type = ? limit 1" , array( "email" ) );
		$systemnumrows = $adb->num_rows( $systemresult );

		if($num_rows > 0){
			$html  = '<div class="row "><div class="col-lg-12"><div class="col-lg-2">';
			$html .= '<span>Select Mail Server<span class="redColor">*</span></span>';
			$html .= '</div><div class="col-lg-6">';
			$html .= '<select data-rule-required ="true" name="serverMSId" id="serverMSId">';
			$html .= '<option value="">Select an option</value>';
			if( $systemnumrows > 0 ) {
				$server_username = $adb->query_result($systemresult,0,'server_username');
				$html .= '<option value="default">'.vtranslate( "Default" , "Vtiger" )." (".$server_username. ")".'</value>';		
			}
			for($i=0;$i<$num_rows;$i++){
				$server_username = $adb->query_result($result,$i,'server_username');
				$server_name = $adb->query_result( $result , $i , "name" );
				$server_id = $adb->query_result($result,$i,'id');
				$sharedusers = Zend_Json::decode( decode_html ( $adb->query_result( $result , $i , "sharedusers" ) ) );
				if(!empty($sharedusers)){
					if( in_array( $current_user_id , $sharedusers ) ) {
						$html .= '<option value="'.$server_id.'">'.$server_name." (".$server_username. ")".'</value>';
					}
				}
			}
			$html .= '</select>';
			$html .= '</div><div class="col-lg-4"></div></div></div>';
			$return = $html;		
		}

		echo($return);
	}
}
?>
