<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Settings_AtomsMSmtp_Record_Model extends Vtiger_Base_Model {

	public function getListViewHeaders(){

		$headers = Array(
					"Name",
					"User Name",	
					"Server Type",	
					"Action"
				);
		return $headers;
	}

	public function getListViewRecords(){
		global $adb,$site_URL;
		$return = Array();
		$sever_labels = Array(
					"tls://smtp.gmail.com:587" => "LBL_GMAIL",
					"smtp.live.com" => "LBL_HOTMAIL",
					"smtp-mail.outlook.com" => "LBL_OFFICE365",
					"smtp.mail.yahoo.com" => "LBL_YAHOO",
				);	
		$result = $adb->pquery("SELECT * FROM vtiger_atoms_msmtp",array());
		$num_rows = $adb->num_rows($result);
		if($num_rows > 0){
			for($i=0;$i<$num_rows;$i++){
				$row = $i+1;
				$id = $adb->query_result($result,$i,'id');
				$return[$row]['id']	 = $id;
				$return[$row]['name'] = $adb->query_result($result,$i,'name');
				$return[$row]['server_username'] = $adb->query_result($result,$i,'server_username');
				$server = $adb->query_result($result,$i,'server');
				if($sever_labels[$server] == ''){
					$server = 'LBL_OTHERS';
				}else{
					$server = $sever_labels[$server];
				}
				$return[$row]['server'] = $server;
				//$return[$row]['config_type'] = $adb->query_result($result,$i,'config_type');
				$return[$row]['editUrl'] = "$site_URL/index.php".$this->getEditViewUrl($id);
			}
		}
		return $return;

	}

	public function getMenuItem() {
                $menuItem = Settings_Vtiger_MenuItem_Model::getInstance('Atom Multiple SMTP');
                return $menuItem;
        }

        public function getEditViewUrl($id = '') {
                $menuItem = $this->getMenuItem();
		if( $id == "" ) {
                	return '?module=AtomsMSmtp&parent=Settings&view=Edit&block='.$menuItem->get('blockid').'&fieldid='.$menuItem->get('fieldid');;
		}
		else{
                	return '?module=AtomsMSmtp&parent=Settings&view=Edit&block='.$menuItem->get('blockid').'&fieldid='.$menuItem->get('fieldid').'&recordId='.$id;
		}
        }

        public function getListViewUrl() {
                $menuItem = $this->getMenuItem();
                return '?module=AtomsMSmtp&parent=Settings&view=List&block='.$menuItem->get('blockid').'&fieldid='.$menuItem->get('fieldid');
        }
	
	public function getRecordDetails($id=""){
		global $adb;
		$columns = Array( "name" , "config_type","userids","server","server_port","server_username","server_password","server_type","smtp_auth","server_path","from_email_field" , "sharedusers" );
		$retun = Array();
		if( $id == "" ) {
			return $columns;
		}
		else{
			$result = $adb->pquery("SELECT * FROM vtiger_atoms_msmtp WHERE id = ? ",array($id));
			$num_rows = $adb->num_rows($result);
			if($num_rows > 0){
				$return['id'] = $id;	
				foreach($columns as $column){
					$return[$column] = $adb->query_result($result,0,$column);
				}
			}
			return $return;
		}
	}



}
