<?php

/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_AtomsMSmtp_serverSaveAjax_Action extends Settings_Vtiger_Basic_Action {
    
	public function process(Vtiger_Request $request) {
		global $current_user;
		$atomsMSmtpServerSettingsModel = Settings_AtomsMSmtp_Systems_Model::getInstanceFromServerType('email', 'AtomsAStmpConfig');
		$loadDefaultSettings = $request->get('default');
		$request->set( 'config_type' , "public" );
		if($request->get('config_type') == 'private'){
			$userids  = json_encode(array($current_user->id));	
		}else{
			$userids = '';  //allow all
		}
		$requestDatas = $request->getAll();
		$requestDatas['userids']  = $userids;

		$requestDatas['sharedusers'] = Zend_Json::encode( $requestDatas['sharedusers'] );

		if($loadDefaultSettings == "true") {
			$atomsMSmtpServerSettingsModel->loadDefaultValues();
		}else{
			$atomsMSmtpServerSettingsModel->setData($requestDatas);
		}

		$response = new Vtiger_Response();
		try{
			if ($loadDefaultSettings == "true") {
				$response->setResult('OK');
			} else {
				$id = $atomsMSmtpServerSettingsModel->save($request);
				$data = $atomsMSmtpServerSettingsModel->getData();
				$response->setResult($data);
			}
		}catch(Exception $e) {
			$response->setError($e->getCode(), $e->getMessage());
		}
		$response->emit();
	}
    
    public function validateRequest(Vtiger_Request $request) {
        $request->validateWriteAccess();
    }
}
