/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
jQuery.Class("Atoms_MSmtp",{},{

	registerSaveServer: function(){
		jQuery(document).find(".atm_saveButton").unbind().click(function(e){
			e.preventDefault();
			var form = jQuery('#AtomsMSmtpConfig');
			var thisInstance = this;
			var aDeferred = jQuery.Deferred();
			var data = form.serializeFormData();
			var params = {
			'module' : app.getModuleName(),
			'parent' : app.getParentModuleName(),
			'action': 'serverSaveAjax'
			};

			jQuery.extend(params,data);
			app.helper.showProgress();
			app.request.post({'data' : params}).then(
					function(err, data) {
						app.helper.hideProgress();
						if(err === null){
								window.location.href ="index.php?parent=Settings&module=AtomsMSmtp&view=List";
						}else {
							jQuery('.errorMessage', form).removeClass('hide');
							aDeferred.reject();
							console.log(data);
						}
					}
					);
			return aDeferred.promise();

		});
	},
	registerOnChangeEventOfserverType : function(){
		 var form = jQuery('#AtomsMSmtpConfig');
            	form.find('[name="serverType"]').on('change',function(e){
			var servertypevalue=form.find('[name="serverType"]').val();
			form.find('[name="server"]').val(servertypevalue);
			if(servertypevalue === "mail.od1.vtiger.com"){
                   			var vtigerUser= form.find('[name="vtigerServer"]').data("username");
                   			var vtigerpassword= form.find('[name="vtigerServer"]').data("password");
                   			var vtigeremail= form.find('[name="vtigerServer"]').data("email");
                    			form.find('[name="server_username"]').val(vtigerUser);
        		            	form.find('[name="server_password"]').val(vtigerpassword);
   	      		           	form.find('[name="from_email_field"]').val(vtigeremail);
                		}else{
                                        form.find('[name="server_username"]').val("");
                                        form.find('[name="server_password"]').val("");
                                        form.find('[name="from_email_field"]').val("");
                                }
                });
	},

	registerCancel : function(){
		jQuery(document).on('click','.atm_cancelLink',function(){
			window.location.href ="index.php?parent=Settings&module=AtomsMSmtp&view=List";

		});
	},
	
	registerDelete : function(){
		jQuery(document).on('click','.atm_row_del',function(e){
			e.preventDefault();
			var serverid = jQuery(this).attr("data-ser-id");	
			console.log(serverid);
			var aDeferred = jQuery.Deferred();
                        var params = {
                        'module' : app.getModuleName(),
                        'parent' : app.getParentModuleName(),
			'serverid':serverid,
                        'action': 'serverDeleteAjax'
                        };

                        jQuery.extend(params,data);
                        app.request.post({'data' : params}).then(
                                        function(err, data) {
                                                if(err === null){
							jQuery(document).find(".row-"+serverid).remove();
                                                }else {
                                                        jQuery('.errorMessage', form).removeClass('hide');
                                                        aDeferred.reject();
                                                        console.log(data);
                                                }
                                        }
                                        );
                        return aDeferred.promise();
			
		});
	},

	registerEvents: function(){
		var thisInstance = this;
		thisInstance.registerSaveServer();
		thisInstance.registerOnChangeEventOfserverType();
		thisInstance.registerCancel();		
		thisInstance.registerDelete();

	}
});

$(document).ready(function(){
		var instance = new Atoms_MSmtp();
		instance.registerEvents();
});
